#include <iostream>
#include <vector>
using namespace std;

struct Nivo {
    int broj_prepreka;
    int velicina_vojske;
    vector<int> faktori_proizvoda;
    vector<int> vrednosti_sabiranja;
    vector<int> min;
    vector<int> max;
};

int getMaxArmySize(Nivo nivo) {
    int velicina = nivo.velicina_vojske;
    for (int i = 0; i < nivo.broj_prepreka; ++i) {
        if (velicina < nivo.min[i] || velicina > nivo.max[i]) {
            return -1; 
        }
        if (velicina * nivo.faktori_proizvoda[i] >= nivo.min[i] &&
            velicina * nivo.faktori_proizvoda[i] <= nivo.max[i]) {
            velicina *= nivo.faktori_proizvoda[i];
        } else if (velicina + nivo.vrednosti_sabiranja[i] >= nivo.min[i] &&
                   velicina + nivo.vrednosti_sabiranja[i] <= nivo.max[i]) {
            velicina += nivo.vrednosti_sabiranja[i];
        } else {
            return -1; 
        }
       
        if (velicina < 0) {
            return velicina;
        }
    }
    return velicina;
}


int main() {
    int T;
    cin >> T;

    for (int i = 0; i < T; ++i) {
        Nivo nivo;
        cin >> nivo.broj_prepreka >> nivo.velicina_vojske;

        nivo.faktori_proizvoda.resize(nivo.broj_prepreka);
        for (int j = 0; j < nivo.broj_prepreka; ++j) {
            cin >> nivo.faktori_proizvoda[j];
        }

        nivo.vrednosti_sabiranja.resize(nivo.broj_prepreka);
        for (int j = 0; j < nivo.broj_prepreka; ++j) {
            cin >> nivo.vrednosti_sabiranja[j];
        }

        nivo.min.resize(nivo.broj_prepreka);
        for (int j = 0; j < nivo.broj_prepreka; ++j) {
            cin >> nivo.min[j];
        }

        nivo.max.resize(nivo.broj_prepreka);
        for (int j = 0; j < nivo.broj_prepreka; ++j) {
            cin >> nivo.max[j];
        }

        int max_velicina = getMaxArmySize(nivo);
        if (max_velicina != -1) {
            cout << max_velicina << endl;
        } else {
            cout << "nemoguce" << endl;
        }
    }

    return 0;
}